
#ifndef DEMO_PROTOTYPE_BDCL_DEMO_SRC_BDCLSMOKETEST_H_
#define DEMO_PROTOTYPE_BDCL_DEMO_SRC_BDCLSMOKETEST_H_
#include <string>
#include <utility/Singleton.h>

namespace adit{ namespace bdcl {
typedef enum
{
    MANUAL,
    AUTOMATIC,
} testMode ;

typedef enum
{
    NODEVICE,
    AOAPNOTSUPPORTED,
    DEVICEALREADYINAOAP,
    INVALIDCHANNELID,
    GSTINTERNAL,
    PHONENOTRESPONDING,
    NOERROR,
} testError;


// Automatic Smoketest
class AutoSmoketest : public adit::utility::Singleton<AutoSmoketest>
{
public:
    AutoSmoketest();
    ~AutoSmoketest();

    void cleanAutoSmoketest();

    //for automatic smoketest
    void setTestMode(testMode mode){stMode = mode; }
    testMode getTestMode(){ return stMode; }
    void setSmoketestTimeout(int timeout){stTimeout = timeout;}
    void setTestError(testError err){stError = err ;}
    testError getTestError(){return stError; }

    std::string& getErrorString(void);

    //handle timer
    void createSignalTimer(void);
    void startSignalTimer(void);
    void setSignalTimer(void);
    void deleteSignalTimer(void);

private:
    testMode   stMode;
    testError  stError;
    timer_t    timerid;
    bool       timerCreated;
    int        stTimeout;
    std::string     errString;
};


} } ////namespace adit bdcl
#endif /* DEMO_PROTOTYPE_BDCL_DEMO_SRC_BDCLSMOKETEST_H_ */
